/////////////////////////////////////////////////////////////
// CINEMA SDK : LISTS        															 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_NODEPLUGIN_H
#define __C4D_NODEPLUGIN_H

#include "c4d_nodedata.h"
#include "c4d_baseplugin.h"

struct NODEPLUGIN : public BASEPLUGIN
{
	LONG					disklevel;
	String*				name;
	void*					emulation;
	LONG*					fallback;
	BaseBitmap*		icon;

	NodeData*			(*Allocator									)(void);
																						
	Bool					(NodeData::*Init						)(GeListNode *node);
	void					(NodeData::*Free						)(GeListNode *node);
	Bool					(NodeData::*Read						)(GeListNode *node, HyperFile *hf, LONG level);
	Bool					(NodeData::*Write						)(GeListNode *node, HyperFile *hf);
	Bool					(NodeData::*CopyTo					)(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
	Bool					(NodeData::*Message					)(GeListNode *node, LONG type, void *data);
	BaseDocument*	(NodeData::*GetDocument			)(GeListNode *node);
	void					(NodeData::*GetBubbleHelp		)(GeListNode *node, String &str);
	Bool					(NodeData::*GetDDescription	)(GeListNode *node, Description *description,LONG &flags);
	Bool					(NodeData::*GetDParameter		)(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
	Bool					(NodeData::*SetDParameter		)(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
	Bool					(NodeData::*GetDEnabling		)(GeListNode *node, const DescID &id,GeData &t_data,LONG flags,const BaseContainer *itemdesc);
	LONG					(NodeData::*GetBranchInfo		)(GeListNode *node, BranchInfo *info, LONG max);

	void*					reserved[(32-13)*C4DPL_MEMBERMULTIPLIER-6];
};

#endif
